/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PathingAOEAugment
extends Augment {
    private static final Map<Block, BlockState> PATH_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.f_50440_, (Object)Blocks.f_152481_.m_49966_()));
    private final int range;

    public PathingAOEAugment(ResourceLocation id, int tier, int range) {
        super(id, tier, EnumSet.of(AugmentType.SHOVEL), PathingAOEAugment.getColor(11177290, tier), PathingAOEAugment.getColor(8743738, tier));
        this.range = range;
    }

    @Override
    public boolean onItemUse(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return false;
        }
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        InteractionHand hand = context.m_43724_();
        boolean playedSound = false;
        if (PathingAOEAugment.tryPath(stack, player, world, pos, direction, hand)) {
            world.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            playedSound = true;
            if (!player.m_6047_()) {
                return false;
            }
        }
        if (player.m_6047_()) {
            Iterator positions = BlockPos.m_121990_((BlockPos)pos.m_7918_(-this.range, 0, -this.range), (BlockPos)pos.m_7918_(this.range, 0, this.range)).iterator();
            while (positions.hasNext()) {
                BlockPos aoePos = (BlockPos)positions.next();
                if (!PathingAOEAugment.tryPath(stack, player, world, aoePos, direction, hand) || playedSound) continue;
                world.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                playedSound = true;
            }
        }
        return true;
    }

    private static boolean tryPath(ItemStack stack, Player player, Level world, BlockPos pos, Direction direction, InteractionHand hand) {
        BlockState state;
        if (direction != Direction.DOWN && world.m_46859_(pos.m_7494_()) && (state = PATH_LOOKUP.get(world.m_8055_(pos).m_60734_())) != null) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, state, 11);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
                }
            }
            return true;
        }
        return false;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

